﻿using System;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace PWS.API.AdvancedAPI.Sample1
{
    public partial class FormMain : Form
    {
        [Flags]
        public enum WindowsMessage : uint
        {
            WM_GETTEXT = 0x000D,
            WM_GETTEXTLENGTH = 0x000E,
            WM_SYSCOMMAND = 0x0112,
            WM_SETTEXT = 0x000C
        }

        [DllImport("user32.dll")]
        public static extern IntPtr SendMessage(IntPtr hWnd, UInt32 msg, IntPtr wParam, [Out] StringBuilder lParam);

        [DllImport("user32.dll", EntryPoint = "SendMessage")]
        public static extern int SendMessage2(IntPtr hWnd, UInt32 msg, IntPtr wParam, [MarshalAs(UnmanagedType.LPStr)] string lParam);

        public FormMain()
        {
            InitializeComponent();
        }

        private void ButtonGetWindowTextClick(object sender, EventArgs e)
        {
            //get window caption text and show
            int length = SendMessage(this.Handle, (uint)WindowsMessage.WM_GETTEXTLENGTH, IntPtr.Zero, null).ToInt32();
            StringBuilder sb = new StringBuilder(length + 1);
            SendMessage(this.Handle, (uint)WindowsMessage.WM_GETTEXT, (IntPtr)sb.Capacity, sb);
            MessageBox.Show(sb.ToString());
        }

        private void ButtonSetTextClick(object sender, EventArgs e)
        {
            IntPtr textBoxHandle = textBoxSample.Handle;

            StringBuilder sb = new StringBuilder("www.PayaWebShomal.com");
            SendMessage2(textBoxHandle, (uint)WindowsMessage.WM_SETTEXT, (IntPtr)sb.Length, sb.ToString());
        }
    }
}